#!/bin/sh
#
# hwmon         This shell script takes care of starting and stopping
#               the hardware monitor service.
#
# description: Hardware monitor monitors temperature of CPUs and many parts of the system
#		It needs many i2c drivers depends on system type.
#

# Source function library.
. /etc/rc.d/init.d/functions

[ -x /usr/sbin/hwmon ] || exit 0

# See how we were called.
case "$1" in
  start)
	# Start daemons.
	echo "Starting Hardware monitor service: "
	echo -n "Starting Hardware monitor: "
	daemon hwmon -d
	echo
	;;
  stop)
	# Stop daemons.
	echo "Shutting down Hardware monitor service: "
	echo -n "Shutting down Hardware monitor: "
	killproc lockd
	echo
	;;
  status)
	status hwmon
	;;
  restart)
	echo -n "Restarting Hardware monitor service: "
	echo -n "hwmon"
	killproc hwmon
	daemon hwmon
	echo "done."
	;;
  *)
	echo "Usage: hwmon {start|stop|status|restart}"
	exit 1
esac

exit 0
